/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PED_CP_IT_SLD]    Script Date: 22/10/2014 09:52:09 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_BUSCA_PRECO_PRODUTO]') 
			AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PED_CP_IT_SLD]
GO
GO

--SELECT DBO.UFD_EST_PED_CP_IT_SLD(1,16,1538, 1)
CREATE FUNCTION [dbo].[UFD_EST_PED_CP_IT_SLD](
												  @CD_EMP		INT,
												  @CD_FILIAL 	INT,
												  @CD_PED		INT,
												  @CD_PROD     INT)
RETURNS MONEY
AS
BEGIN

	DECLARE @QT_SLD			MONEY, 
			@QT_IT_NF		MONEY, 
			@QT_IT_CANCEL	MONEY,
			@QT_IT_SLD_FINAL MONEY;
	--BUSCA O SALDO INICIAL
	SET @QT_SLD = (SELECT (EST_PED_CP_IT.QT_IT * EST_PED_CP_IT.QT_EMB)
						FROM         
							EST_PED_CP_IT
						WHERE
							EST_PED_CP_IT.CD_EMP		= @CD_EMP
							AND EST_PED_CP_IT.CD_FILIAL = @CD_FILIAL
							AND EST_PED_CP_IT.CD_PED	= @CD_PED 
							AND EST_PED_CP_IT.CD_PROD	= @CD_PROD)


	--BUSCA A QUANTIDADE DE ENTRADA NAS NOTAS FISCAIS  
	SET @QT_IT_NF =	(SELECT     
						SUM(EST_NF_ENT_IT.QT_IT) AS QT_IT
					FROM         
						EST_NF_ENT_IT 
						INNER JOIN EST_NF_ENT_PED_CP ON 
						EST_NF_ENT_IT.CD_EMP	= EST_NF_ENT_PED_CP.CD_EMP AND 
						EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_PED_CP.CD_FILIAL AND 
						EST_NF_ENT_IT.CD_NF		= EST_NF_ENT_PED_CP.CD_NF
					WHERE     
						EST_NF_ENT_IT.CD_EMP		= @CD_EMP
						AND EST_NF_ENT_IT.CD_PROD	= @CD_PROD
						AND EST_NF_ENT_IT.CD_FILIAL	= @CD_FILIAL
						AND EST_NF_ENT_PED_CP.CD_PED = @CD_PED)

	--BUSCA A QUANTIDADE CANCELADA
	SET @QT_IT_CANCEL = ( SELECT     
								SUM (C.QT_PROD*i.QT_EMB) AS QT_IT
							FROM         
								EST_PED_CP_IT_CANCEL_SLD c 
								INNER JOIN EST_PED_CP_IT i ON
								c.CD_EMP	= i.CD_EMP AND
								c.CD_FILIAL = i.CD_FILIAL AND
								c.CD_PED	= i.CD_PED AND
								c.CD_PROD	= i.CD_PROD 
							WHERE     
								c.CD_EMP		= @CD_EMP
								AND c.CD_FILIAL = @CD_FILIAL
								AND c.CD_PED	= @CD_PED 
								AND c.CD_PROD	= @CD_PROD )
 
	SET @QT_IT_SLD_FINAL=	ISNULL(@QT_SLD,0) - (ISNULL(@QT_IT_NF,0) + ISNULL(@QT_IT_CANCEL,0))

	 IF @QT_IT_SLD_FINAL < 0
	 BEGIN
		SET @QT_IT_SLD_FINAL=0
	 END

	RETURN(@QT_IT_SLD_FINAL)
END


